/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fabric.transfer;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.fabric.transfer.IInventoryStorage;
import slimeknights.mantle.fabric.transfer.InventorySlotWrapper;
import slimeknights.mantle.fabric.transfer.PlayerInventoryStorage;
import slimeknights.mantle.fabric.transfer.SidedInventoryStorage;

public class InventoryStorage
extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>>
implements IInventoryStorage {
    private static final Map<class_1263, InventoryStorage> WRAPPERS = new MapMaker().weakValues().makeMap();
    final class_1263 inventory;
    final List<InventorySlotWrapper> backingList;
    final MarkDirtyParticipant markDirtyParticipant = new MarkDirtyParticipant();

    public static IInventoryStorage of(class_1263 inventory, @Nullable class_2350 direction) {
        InventoryStorage storage = WRAPPERS.computeIfAbsent(inventory, inv -> {
            if (inv instanceof class_1661) {
                class_1661 playerInventory = (class_1661)inv;
                return new PlayerInventoryStorage(playerInventory);
            }
            return new InventoryStorage((class_1263)inv);
        });
        storage.resizeSlotList();
        return storage.getSidedWrapper(direction);
    }

    InventoryStorage(class_1263 inventory) {
        super(Collections.emptyList());
        this.inventory = inventory;
        this.backingList = new ArrayList<InventorySlotWrapper>();
    }

    @Override
    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int inventorySize = this.inventory.method_5439();
        if (inventorySize != this.parts.size()) {
            while (this.backingList.size() < inventorySize) {
                this.backingList.add(new InventorySlotWrapper(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, inventorySize));
        }
    }

    private IInventoryStorage getSidedWrapper(@Nullable class_2350 direction) {
        if (this.inventory instanceof class_1278 && direction != null) {
            return new SidedInventoryStorage(this, direction);
        }
        return this;
    }

    public String toString() {
        return "InventoryStorage[" + DebugMessages.forInventory((class_1263)this.inventory) + "]";
    }

    public class_1799 getStackInSlot(int slot) {
        return this.inventory.method_5438(slot);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.method_5438(slot).method_7914();
    }

    class MarkDirtyParticipant
    extends SnapshotParticipant<Boolean> {
        MarkDirtyParticipant() {
        }

        protected Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        protected void readSnapshot(Boolean snapshot) {
        }

        protected void onFinalCommit() {
            InventoryStorage.this.inventory.method_5431();
        }
    }
}

